//
// 	NetFilterSDK 
// 	Copyright (C) Vitaly Sidorov
//	All rights reserved.
//
//	This file is a part of the NetFilter SDK.
//	The code and information is provided "as-is" without
//	warranty of any kind, either expressed or implied.
//

#pragma once

#include "vlist.h"

namespace mainNS
{
	struct _VBUFFER;

	typedef _VBUFFER* vbuffer_t;

	vbuffer_t   vbuffer_create();
	void        vbuffer_free(vbuffer_t b);
	BOOL        vbuffer_copy(vbuffer_t b, vbuffer_t from);
	BOOL        vbuffer_append(vbuffer_t b, const char* buf, unsigned long len, bool copy);
	BOOL        vbuffer_appendByte(vbuffer_t b, char c);
	BOOL        vbuffer_appendString(vbuffer_t b, const char * str);
#ifdef WIN32
	BOOL        vbuffer_appendWString(vbuffer_t b, const wchar_t * str);
#endif
	unsigned long vbuffer_getSize(vbuffer_t b);
	void        vbuffer_reset(vbuffer_t b);
	void        vbuffer_clear(vbuffer_t b);
	char *      vbuffer_buffer(vbuffer_t b);
	void        vbuffer_setLimit(vbuffer_t b, unsigned long limit);
	void        vbuffer_setReservePercent(vbuffer_t b, unsigned long reservePercent);
	PVLIST_ENTRY vbuffer_getListEntry(vbuffer_t b);
	vbuffer_t   vbuffer_fromListEntry(PVLIST_ENTRY listEntry);

}