//
// 	NetFilterSDK 
// 	Copyright (C) Vitaly Sidorov
//	All rights reserved.
//
//	This file is a part of the NetFilter SDK.
//	The code and information is provided "as-is" without
//	warranty of any kind, either expressed or implied.
//

#pragma once

namespace mainNS
{
#ifdef WIN32

	typedef HANDLE vthread_t;
	#define VTHREAD_FUNC unsigned WINAPI
	typedef unsigned (WINAPI * VTHREAD_START)(void*);

#else

	#include <pthread.h>
	typedef pthread_t vthread_t;
	#define VTHREAD_FUNC void *
	typedef void *(* VTHREAD_START)(void*);

#endif

	vthread_t vthread_create(VTHREAD_START start_routine, void* arg);
	void vthread_wait(vthread_t b);
}